#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "dialog_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"
#include "game/level_update.h"
#include "levels/scripts.h"
#include "actors/common1.h"
#include "make_const_nonconst.h"

#include "areas/1/custom.model.inc.h"

#include "levels/bob/header.h"
extern u8 _bob_segment_ESegmentRomStart[];
extern u8 _bob_segment_ESegmentRomEnd[];

const LevelScript level_bob_entry[] = {
INIT_LEVEL(),
LOAD_MIO0(0x07, _bob_segment_7SegmentRomStart, _bob_segment_7SegmentRomEnd),
LOAD_RAW(0x1A, _bobSegmentRomStart, _bobSegmentRomEnd),
LOAD_RAW(0x0E, _bob_segment_ESegmentRomStart, _bob_segment_ESegmentRomEnd),
LOAD_MIO0(0xA, _water_skybox_mio0SegmentRomStart, _water_skybox_mio0SegmentRomEnd),
LOAD_MIO0(8, _common0_mio0SegmentRomStart, _common0_mio0SegmentRomEnd),
LOAD_RAW(15, _common0_geoSegmentRomStart, _common0_geoSegmentRomEnd),
LOAD_MIO0(5, _group11_mio0SegmentRomStart, _group11_mio0SegmentRomEnd),
LOAD_RAW(12, _group11_geoSegmentRomStart, _group11_geoSegmentRomEnd),
LOAD_MIO0(6, _group14_mio0SegmentRomStart, _group14_mio0SegmentRomEnd),
LOAD_RAW(13, _group14_geoSegmentRomStart, _group14_geoSegmentRomEnd),
ALLOC_LEVEL_POOL(),
MARIO(/*model*/ MODEL_MARIO, /*behParam*/ 0x00000001, /*beh*/ bhvMario),
// Level Specific Models
LOAD_MODEL_FROM_GEO(MODEL_BOB_BUBBLY_TREE,      bubbly_tree_geo),
LOAD_MODEL_FROM_GEO(MODEL_BOB_CHAIN_CHOMP_GATE, bob_geo_000440),
LOAD_MODEL_FROM_GEO(MODEL_BOB_SEESAW_PLATFORM,  bob_geo_000458),
LOAD_MODEL_FROM_GEO(MODEL_BOB_BARS_GRILLS,      bob_geo_000470),
// Unspecified Models
LOAD_MODEL_FROM_GEO(22,  warp_pipe_geo),
LOAD_MODEL_FROM_GEO(23,  bubbly_tree_geo),
LOAD_MODEL_FROM_GEO(24,  spiky_tree_geo),
LOAD_MODEL_FROM_GEO(25,  snow_tree_geo),
LOAD_MODEL_FROM_GEO(27,  palm_tree_geo),
LOAD_MODEL_FROM_GEO(31,  metal_door_geo),
LOAD_MODEL_FROM_GEO(32,  hazy_maze_door_geo),
LOAD_MODEL_FROM_GEO(34,  castle_door_0_star_geo),
LOAD_MODEL_FROM_GEO(35,  castle_door_1_star_geo),
LOAD_MODEL_FROM_GEO(36,  castle_door_3_stars_geo),
LOAD_MODEL_FROM_GEO(37,  key_door_geo),
LOAD_MODEL_FROM_GEO(38,  castle_door_geo),
// LOAD_MODEL_FROM_GEO(88, 0x0500c778),
// LOAD_MODEL_FROM_DL(132, 0x08025f08, 4),
// LOAD_MODEL_FROM_DL(158, 0x0302c8a0, 4),
// LOAD_MODEL_FROM_DL(159, 0x0302bcd0, 4),
// LOAD_MODEL_FROM_DL(161, 0x0301cb00, 4),
// LOAD_MODEL_FROM_DL(164, 0x04032a18, 4),
// LOAD_MODEL_FROM_DL(201, 0x080048e0, 4),
// LOAD_MODEL_FROM_DL(218, 0x08024bb8, 4),
JUMP_LINK(script_func_global_1),
JUMP_LINK(script_func_global_12),
JUMP_LINK(script_func_global_15),
JUMP_LINK(local_area_bob_1_),
FREE_LEVEL_POOL(),
MARIO_POS(/* area */ 1, /* yaw */ 0, /* pos */ 0, 0, 0),
CALL(/*arg*/ 0, /*func*/ lvl_init_or_update),
CALL_LOOP(/*arg*/ 1, /*func*/ lvl_init_or_update),
CLEAR_LEVEL(),
SLEEP_BEFORE_EXIT(/*frames*/ 1),
EXIT(),
};

const LevelScript local_area_bob_1_[] = {
AREA(1, Geo_bob_1_0x12d8480),
TERRAIN(col_bob_1_0xe04eae0),
SET_BACKGROUND_MUSIC(0, 45),
TERRAIN_TYPE(0),
JUMP_LINK(local_objects_bob_1_),
JUMP_LINK(local_warps_bob_1_),
END_AREA(),
RETURN()
};

const LevelScript local_objects_bob_1_[] = {
OBJECT_WITH_ACTS(0, 5714, 574, -5481, 0, 270, 0, 0xa0000,  bhvSpinAirborneWarp, 31),
OBJECT_WITH_ACTS(122, -2346, 3656, -107, 0, 0, 0, 0x0,  bhvStar, 31),
OBJECT_WITH_ACTS(122, 4023, 3256, 5526, 0, 0, 0, 0x2000000,  bhvStar, 31),
OBJECT_WITH_ACTS(0, -4171, 2094, 5168, 0, 0, 0, 0x3000000,  bhvHiddenRedCoinStar, 31),
OBJECT_WITH_ACTS(122, -1512, 5056, -5363, 0, 0, 0, 0x4000000,  bhvStar, 31),
OBJECT_WITH_ACTS(122, -3801, -1450, -5166, 0, 0, 0, 0x5000000,  bhvStar, 31),
OBJECT_WITH_ACTS(104, -1309, 0, -5161, 0, 0, 0, 0x1020000,  bhvKoopa, 2),
OBJECT_WITH_ACTS(0, -540, 3400, 2839, 0, 0, 0, 0x0,  bhvKoopaRaceEndpoint, 2),
OBJECT_WITH_ACTS(215, 4510, -259, -4400, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 2285, -351, -1208, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 1184, 145, -6549, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -2748, 149, -3889, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 831, 1149, -646, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 710, 1149, 6237, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 3256, 649, 907, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 5483, 1300, 2525, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(201, 5591, 503, -402, 0, 71, 0, 0x800000,  bhvCannonClosed, 31),
OBJECT_WITH_ACTS(195, 4696, 97, -4437, 0, 0, 0, 0x0,  bhvBobombBuddyOpensCannon, 60),
OBJECT_WITH_ACTS(137, 1434, 256, -6533, 0, 0, 0, 0x0,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, 6156, 1356, -1532, 0, 0, 0, 0x0,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(89, -3178, -1300, -5372, 0, 0, 0, 0x0,  bhvBubba, 31),
OBJECT_WITH_ACTS(89, -4288, -1200, -4942, 0, 0, 0, 0x0,  bhvBubba, 31),
OBJECT_WITH_ACTS(0, -1720, 2800, -1125, 0, 90, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 4123, 1129, -1296, 0, 90, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 5754, 2150, 3862, 0, 90, 0, 0x120000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 2537, 100, -5497, 0, 90, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -1472, 3000, 1559, 0, 90, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -1733, 775, -1735, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 2285, 1000, 1706, 0, 90, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 197, 0, -5029, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(0, 5083, 500, 1078, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(0, -4809, 1000, 3767, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(104, -510, 0, -6390, 0, 0, 0, 0x0,  bhvKoopa, 60),
OBJECT_WITH_ACTS(0, -1273, 2300, 4577, 0, 86, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -1330, 3500, 4080, 0, 86, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(100, 1633, 1000, 380, 0, 0, 0, 0x0,  bhvPiranhaPlant, 31),
OBJECT_WITH_ACTS(100, 4696, 500, 3779, 0, 0, 0, 0x0,  bhvPiranhaPlant, 31),
OBJECT_WITH_ACTS(100, 5585, -500, -3139, 0, 0, 0, 0x0,  bhvPiranhaPlant, 31),
OBJECT_WITH_ACTS(100, -4663, 1000, -1603, 0, 0, 0, 0x0,  bhvPiranhaPlant, 31),
OBJECT_WITH_ACTS(100, -1710, 1000, 5616, 0, 0, 0, 0x0,  bhvPiranhaPlant, 31),
OBJECT_WITH_ACTS(192, 3281, -265, -4941, 0, 0, 0, 0x0,  bhvGoomba, 31),
OBJECT_WITH_ACTS(192, 2764, -159, -5793, 0, 0, 0, 0x0,  bhvGoomba, 31),
OBJECT_WITH_ACTS(188, 2205, -500, -2547, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, 5644, 500, 4661, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, 2584, -476, -3695, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, 3642, 500, 4170, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(192, 1181, 1000, -1145, 0, 0, 0, 0x0,  bhvGoomba, 31),
OBJECT_WITH_ACTS(192, 1917, 1000, 3595, 0, 0, 0, 0x0,  bhvGoomba, 31),
OBJECT_WITH_ACTS(212, 121, 2200, -2928, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(23, 517, 1000, 5419, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, -5393, 1000, 2297, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, 622, 1000, -1564, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, -3330, 1000, -2268, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, -2402, 3400, 3223, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, -3258, 3400, 976, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, -757, 3400, -103, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, 4983, -493, -2340, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, 3634, -344, -4029, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, 607, 0, -6275, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, -5462, 0, -3619, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, 274, 0, -3487, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, 6130, 500, 862, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, 6163, 500, 3343, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, 3463, 500, 1590, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, 5171, 500, 5875, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(23, 3512, 500, 4992, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(187, 5667, -450, -3370, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, 5709, -450, -2841, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, 5872, 550, -549, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, 5310, 550, -350, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, 4805, 500, 3780, 0, 0, 0, 0x0,  bhvTripletButterfly, 31),
OBJECT_WITH_ACTS(187, 1843, 1050, 589, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, 1638, 1050, 122, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, -1077, 1050, 5546, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, -1951, 1050, 5346, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, -1904, 1050, 5931, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, -4667, 1050, -1474, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(187, -4269, 1050, -1793, 0, 0, 0, 0x0,  bhvButterfly, 31),
OBJECT_WITH_ACTS(140, 5448, 1100, 5142, 0, 345, 0, 0x0,  bhvBlueCoinSwitch, 31),
OBJECT_WITH_ACTS(118, 4364, 1045, 4552, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, 3371, 1000, 3540, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, 3420, 850, 3056, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(107, 5170, 500, 6405, 0, 0, 0, 0x0,  bhvWoodenPost, 31),
OBJECT_WITH_ACTS(124, -1472, 0, -5674, 0, 105, 0, 0x270000,  bhvMessagePanel, 31),
OBJECT_WITH_ACTS(0, -8, 4, 15, 0, 0, 20, 0,  RM_Scroll_Texture, 31),
RETURN()
};

const LevelScript local_warps_bob_1_[] = {
WARP_NODE(10, 9, 1, 0, 0),
WARP_NODE(240, 6, 1, 41, 0),
WARP_NODE(241, 6, 1, 51, 0),
RETURN()
};
